TYPE
  LOGLEVEL : (CRITICAL, WARNING, INFO, DEBUG) := INFO;
END_TYPE

FUNCTION_BLOCK LOGGER
  VAR_INPUT
    TRIG : BOOL;
    MSG : STRING;
    LEVEL : LOGLEVEL := INFO;
  END_VAR
  VAR
    TRIG0 : BOOL;
  END_VAR

  IF TRIG AND NOT TRIG0 THEN
  {{
   LogMessage(GetFbVar(LEVEL),(char*)GetFbVar(MSG, .body),GetFbVar(MSG, .len));
  }}
  END_IF;
  TRIG0:=TRIG;
END_FUNCTION_BLOCK



FUNCTION_BLOCK python_eval
  VAR_INPUT
    TRIG : BOOL;
    CODE : STRING;
  END_VAR
  VAR_OUTPUT
    ACK : BOOL;
    RESULT : STRING;
  END_VAR
  VAR
    STATE : DWORD;
    BUFFER : STRING;
    PREBUFFER : STRING;
    TRIGM1 : BOOL;
    TRIGGED : BOOL;
  END_VAR

  {extern void __PythonEvalFB(int, PYTHON_EVAL*);__PythonEvalFB(0, data__);}
END_FUNCTION_BLOCK

FUNCTION_BLOCK python_poll
  VAR_INPUT
    TRIG : BOOL;
    CODE : STRING;
  END_VAR
  VAR_OUTPUT
    ACK : BOOL;
    RESULT : STRING;
  END_VAR
  VAR
    STATE : DWORD;
    BUFFER : STRING;
    PREBUFFER : STRING;
    TRIGM1 : BOOL;
    TRIGGED : BOOL;
  END_VAR

  {extern void __PythonEvalFB(int, PYTHON_EVAL*);__PythonEvalFB(1,(PYTHON_EVAL*)(void*)data__);}
END_FUNCTION_BLOCK

FUNCTION_BLOCK python_gear
  VAR_INPUT
    N : UINT;
    TRIG : BOOL;
    CODE : STRING;
  END_VAR
  VAR_OUTPUT
    ACK : BOOL;
    RESULT : STRING;
  END_VAR
  VAR
    py_eval : python_eval;
    COUNTER : UINT;
    ADD10_OUT : UINT;
    EQ13_OUT : BOOL;
    SEL15_OUT : UINT;
    AND7_OUT : BOOL;
  END_VAR

  ADD10_OUT := ADD(COUNTER, 1);
  EQ13_OUT := EQ(N, ADD10_OUT);
  SEL15_OUT := SEL(EQ13_OUT, ADD10_OUT, 0);
  COUNTER := SEL15_OUT;
  AND7_OUT := AND(EQ13_OUT, TRIG);
  py_eval(TRIG := AND7_OUT, CODE := CODE);
  ACK := py_eval.ACK;
  RESULT := py_eval.RESULT;
END_FUNCTION_BLOCK


PROGRAM PWM_Modbus_DA
  VAR
    DA1 : INT;
    DA2 : INT;
    DA3 : INT;
    DA4 : INT;
    AD1 : INT;
    AD2 : INT;
    AD3 : INT;
    AD4 : INT;
    AD5 : INT;
    AD6 : INT;
    Taster1 : BOOL;
    Taster2 : BOOL;
    Taster3 : BOOL;
    Taster4 : BOOL;
    Taster5 : BOOL;
    LED1 : BOOL;
    LED2 : BOOL;
    LED3 : BOOL;
    LED4 : BOOL;
  END_VAR
  VAR
    MyTimer : TON;
    MyTimerDone : BOOL := FALSE;
    MyTimerET : TIME;
    Counter : INT := 0;
  END_VAR

  Counter := Counter + 100;
  (*PWM Ausgänge*)
  DA1:= Counter;
  DA2:= Counter;
  DA3:= Counter;
  DA4:= Counter;  

  IF Counter=30000 THEN Counter:=0; END_IF;

  (* LED blinken lassen *)
  MyTimer(IN:= NOT MyTimer.Q,PT:=T#255ms,Q=>MyTimerDone,ET=>MyTimerET);

  if MyTimerDone then 
    LED1:=NOT LED1;
    LED2:=NOT LED2;
    LED3:=NOT LED3;
    LED4:=NOT LED4;
  end_if;

END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    TASK task0(INTERVAL := T#100ms,PRIORITY := 10);
    PROGRAM instance0 WITH task0 : PWM_Modbus_DA;
  END_RESOURCE
END_CONFIGURATION
